# Copyright (c) 2004 Brian Dam Pedersen
# 
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
from Numeric import *
import QP

# Small test blatantly ripped from scilab - however scilab has different direction on the inequalities,
# hence the minus in front of C
C=-array([[ 1., -1.,  1.,  0.,  3.,  1.],\
         [-1.,  0., -3., -4.,  5.,  6.],\
         [ 2.,  5.,  3.,  0.,  1.,  0.],\
         [ 0.,  1.,  0.,  1.,  2., -1.],\
         [-1.,  0.,  2.,  1.,  1.,  0.]])
b=array([ 1. ,  2. ,  3. , -1. ,  2.5])
Q=identity(6,Float)
p=array(range(1,7),Float)
ci=array([ -1000., -10000.,      0.,  -1000.,  -1000.,  -1000.])
cs=array([  1.0e+04,   1.0e+02,   1.5e+00,   1.0e+02, 1.0e+02,   1.0e+03])

x=QP.qp(Q,p,C,b,eq_c=3,xl=ci,xu=cs,output=0)

print "Result:"
print x
print "Expected:"
print "[ 1.7975426  -0.33814872  0.16338803 -4.98840227  0.60549433 -3.11556234]"


